using System;

using Microsoft.SqlServer.Server;

namespace Misc
{

    public class TextRoutines
    {
        [SqlFunction(DataAccess = DataAccessKind.Read)]
        public static string ExpandWithExclamationMarks(string s)
        {
            return "!!!" + s + "!!!";
        }

        [SqlFunction(DataAccess = DataAccessKind.Read)]
        public static string ToLeet(string s)
        {
            string newstring = "";
            Random rand = new Random();

            foreach (char ch in s)
                switch (ch)
                {
                    case 'a':
                        newstring += "@";
                        break;
                    case 'A':
                        if (rand.Next(2) > 0)
                            newstring += @"/-\";
                        else
                            newstring += "@";
                        break;
                    case 'B':
                        newstring += "8";
                        break;
                    case 'D':
                        newstring += "|)";
                        break;
                    case 'e':
                    case 'E':
                        newstring += "3";
                        break;
                    case 'g':
                        newstring += "9";
                        break;
                    case 'h':
                        newstring += "4";
                        break;
                    case 'H':
                        newstring += "|-|";
                        break;
                    case 'i':
                    case 'I':
                        newstring += "1";
                        break;
                    case 'K':
                        newstring += "|<";
                        break;
                    case 'l':
                    case 'L':
                        if (rand.Next(3) > 1)
                            newstring += "|_";
                        else
                            newstring += ch;
                        break;
                    case 'm':
                    case 'M':
                        newstring += @"|\/|";
                        break;
                    case 'n':
                    case 'N':
                        newstring += @"|\|";
                        break;
                    case 'o':
                    case 'O':
                        newstring += "0";
                        break;
                    case 's':
                    case 'S':
                        newstring += "5";
                        break;
                    case 't':
                    case 'T':
                        if (rand.Next(3) > 1)
                            newstring += "+";
                        else
                            newstring += ch;
                        break;
                    case 'u':
                    case 'U':
                        newstring += "|_|";
                        break;
                    case 'v':
                    case 'V':
                        newstring += @"\/";
                        break;
                    case 'w':
                    case 'W':
                        newstring += @"\/\/";
                        break;
                    case 'x':
                    case 'X':
                        newstring += "><";
                        break;
                    case 'z':
                    case 'Z':
                        newstring += "2";
                        break;
                    default:
                        newstring += ch;
                        break;
                }
            return newstring;
        }

    }

}